<?php

namespace App\Repositories;

use App\Models\AdsConfiguration;
use App\Models\AppConfiguration;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Cache;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;

/**
 * Class AppConfigurationRepository
 */
class AdsConfigurationRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     *
     * @return array|mixed|string[]
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     *
     *
     * @return string
     */
    public function model()
    {
        return AdsConfiguration::class;
    }

    /**
     * @param $input
     * @param $userId
     *
     *
     * @return Builder|Builder|Collection|Model|void
     */
    public function update($input, $userId)
    {
        $inputArr = Arr::except($input, ['_token']);
        $inputArr['ads_type'] = isset($inputArr['ads_type']) ? '1' : '0';
        
        foreach ($inputArr as $key => $value) {
            $adsData = AdsConfiguration::where('key', $key)->first();
            if (!$adsData) {
                continue;
            }
            $adsData->update(['value' => $value]);
        }
    }
}
