<?php

namespace App\Models;

use App\Models\Contracts\JsonResourceful;
use Barryvdh\LaravelIdeHelper\Eloquent;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;
use Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

/**
 * App\Models\BottomNavigationStyle
 *
 * @property int $id
 * @property string $title
 * @property string|null $url
 * @property string $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read string $bottom_image
 * @property-read MediaCollection|Media[] $media
 * @property-read int|null $media_count
 * @method static Builder|BottomNavigationStyle newModelQuery()
 * @method static Builder|BottomNavigationStyle newQuery()
 * @method static Builder|BottomNavigationStyle query()
 * @method static Builder|BottomNavigationStyle whereCreatedAt($value)
 * @method static Builder|BottomNavigationStyle whereId($value)
 * @method static Builder|BottomNavigationStyle whereStatus($value)
 * @method static Builder|BottomNavigationStyle whereTitle($value)
 * @method static Builder|BottomNavigationStyle whereUpdatedAt($value)
 * @method static Builder|BottomNavigationStyle whereUrl($value)
 * @mixin Eloquent
 */
class BottomNavigationStyle extends Model implements HasMedia, JsonResourceful
{
    use HasFactory, InteractsWithMedia;

    protected $table = 'bottom_navigation_styles';

    protected $fillable = [
        'title',
        'url',
        'status',
    ];

    protected $with = ['media'];

    const IMAGE = 'bottom_image';
    protected $appends = ['bottom_image'];
    const ACTIVE = 1;
    const INACTIVE = 0;

    const STATUS = [
        self::ACTIVE   => 'Active',
        self::INACTIVE => 'Inactive',
    ];
    public static $rules = [
        'title' => 'required',
    ];

    public function getBottomImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::IMAGE)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }

    public function prepareAttributes(): array
    {
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'url'       => $this->url,
            'status'    => $this->status,
            'image_url' => $this->getMedia(self::IMAGE)->first()->getFullUrl(),

        ];
    }
}
