<?php

namespace App\Http\Livewire;

use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\WalkThrough;

class WalkThroughTable extends LivewireTableComponent
{
    protected $model = WalkThrough::class;
    public $showButtonOnHeader = true;
    public $buttonComponent = 'walk_through.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function resetPage($pageName = 'page')
        
    {
        $rowsPropertyData = $this->getRows()->toArray();
        $prevPageNum = $rowsPropertyData['current_page'] - 1;
        $prevPageNum = $prevPageNum > 0 ? $prevPageNum : 1;
        $pageNum = count($rowsPropertyData['data']) > 0 ? $rowsPropertyData['current_page'] : $prevPageNum;

        $this->setPage($pageNum, $pageName);
    }
    
    public function configure(): void
    {
        $this->setPrimaryKey('id');
    }

    public function columns(): array
    {
        return [
            Column::make("Screen", "screen")
                ->view('walk_through.columns.screen'),
            Column::make("Title", "title")
                ->view('walk_through.columns.title')
                ->searchable()
                ->sortable(),
            Column::make("Subtitle", "subtitle")
                ->view('walk_through.columns.subtitle')
                ->searchable()
                ->sortable(),
//            Column::make("Status", "status")
//                ->view('walk_through.columns.status')
//                ->searchable()
//                ->sortable(),
            Column::make("action", "id")
                ->view('walk_through.columns.action')
                ->sortable(),
        ];
    }
    
}
