<?php

namespace App\Http\Livewire;

use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\LeftHeaderNavigation;

class LeftHeaderNavigationTable extends LivewireTableComponent
{
    protected $model = LeftHeaderNavigation::class;

//    public $showButtonOnHeader = true;
//    public $buttonComponent = 'left_header_navigation.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function resetPage($pageName = 'page')
    {
        $rowsPropertyData = $this->getRows()->toArray();
        $prevPageNum = $rowsPropertyData['current_page'] - 1;
        $prevPageNum = $prevPageNum > 0 ? $prevPageNum : 1;
        $pageNum = count($rowsPropertyData['data']) > 0 ? $rowsPropertyData['current_page'] : $prevPageNum;

        $this->setPage($pageNum, $pageName);
    }

    public function configure(): void
    {
        $this->setPrimaryKey('id')
            ->setDefaultSort('left_header_navigations.created_at', 'desc')
            ->setQueryStringStatus(false);
    }

    public function columns(): array
    {
        return [
            Column::make("Title", "title")
                ->view('left_header_navigation.columns.title')
                ->sortable(),
            Column::make("Image", "id")
                ->view('left_header_navigation.columns.navigation_image')
                ->sortable(),
            Column::make("URL", "url")
                ->view('left_header_navigation.columns.url')
                ->sortable(),
            Column::make(__('STATUS'), "status")
                ->view('left_header_navigation.columns.status'),
            Column::make(__('ACTION'), "active")
                ->view('left_header_navigation.action-button'),
        ];
    }
}
