<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateOneSignalConfigurationRequest;
use App\Jobs\SendOneSignalPushJob;
use App\Models\OneSignalConfiguration;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use OneSignal;

class OneSignalSendController extends Controller
{
    /**
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('one_signal_notification.send.index');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return void
     */
    public function store(UpdateOneSignalConfigurationRequest $request)
    {
        $input = $request->all();
        $oneSignal = OneSignalConfiguration::find(1);
        $image = 'https://invoices-saas.infyom.com/assets/images/infyom.png';
        if (!empty($oneSignal)) {
            if ($request->hasFile('one_signal_image')) {
                $oneSignal->clearMediaCollection(OneSignalConfiguration::SIGNAL_IMAGE);
                $oneSignal->addMedia($input['one_signal_image'])->toMediaCollection(OneSignalConfiguration::SIGNAL_IMAGE);
            }
            $image = $oneSignal->signal_image;
        }

        dispatch(new SendOneSignalPushJob($input['url'], $input['title'], $input['message'], $image));

        return redirect(route('onesignal-send.index'));
    }
}
