<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateFloatingButtonRequest;
use App\Models\FloatingButton;
use App\Repositories\FloatingButtonRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class FloatingButtonController extends AppBaseController
{

    /**
     * @param FloatingButtonRepository $FloatingButtonRepo
     */
    public function __construct(FloatingButtonRepository $FloatingButtonRepo)
    {
        $this->buttonRepository = $FloatingButtonRepo;
    }

    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('floating_button.index');
    }


    /**
     *
     */
    public function create()
    {
        //
    }


    /**
     * @param CreateFloatingButtonRequest $request
     *
     *
     * @return JsonResponse
     */
    public function store(CreateFloatingButtonRequest $request)
    {

        $input = $request->all();
        $input['status'] = isset($input['status']) ? 1 : 0;
        $button = $this->buttonRepository->store($input);

        return $this->sendSuccess(__('Floating Button Created Successfully.'));
    }

    /**
     * @param $id
     *
     */
    public function show($id)
    {
        //
    }

    /**
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function edit($id)
    {

        $product = FloatingButton::where('id', $id)->first();

        return $this->sendResponse($product, 'Floating Button Retrieve Successfully.');
    }

    /**
     * @param Request $request
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function update(Request $request, $id)
    {

        $input = $request->all();
        $button = $this->buttonRepository->update($input, $id);

        return $this->sendResponse($button, 'Floating Button Update successfully.');

    }

    /**
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function destroy($id)
    {
        $button = FloatingButton::whereId($id)->first();
        $button->clearMediaCollection(FloatingButton::FLOATING_BUTTON_IMAGE);
        $button->delete();

        return $this->sendSuccess('Floating Button deleted successfully.');
    }

    public function changeBottomNavStatus(Request $request)
    {
        $floatingButton = FloatingButton::findOrFail($request->id);
        $floatingButton->update(['status' => !$floatingButton->status]);

        return $this->sendResponse($floatingButton, 'Floating Button Status Update Successfully');
    }
}
