<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateAppConfigurationRequest;
use App\Models\AppConfiguration;
use App\Repositories\AppConfigurationRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;

class AppConfigurationController extends Controller
{

    /**
     * @param AppConfigurationRepository $appConfigRepository
     */
    public function __construct(AppConfigurationRepository $appConfigRepository)
    {
        $this->appConfigRepository = $appConfigRepository;
    }


    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    { 
        $appLanguages = AppConfiguration::LANGUAGES;
        $navigationStyles = AppConfiguration::NAVIGATION_STYLE;
        $headerStyles = AppConfiguration::HEADER_STYLE;
        $appConfigs = AppConfiguration::pluck('value', 'key')->toArray();
      
        return view('app_configurations.index', compact('appLanguages','navigationStyles','headerStyles','appConfigs'));
    }


    /**
     * @param UpdateAppConfigurationRequest $request
     *
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     *
     * @return RedirectResponse
     */
    public function update(UpdateAppConfigurationRequest $request)
    {
        $id = 1;
        
        $this->appConfigRepository->update($request->all(), $id);

        Flash::success( 'App Configuration Updated Successfully');

        return Redirect::back();
    }
}
